#include <File.au3>
#include <Array.au3>
#include <Constants.au3>

Global Const $asStandartMerge[4] = ['AutoIt3.chm', 'AutoIt3 TOC.hhc', 'UDFs3.chm', 'UDFs3 TOC.hhc']
Global Const $sPatternObject = '  <object type="text/sitemap">' & @CRLF & _
							'    <param name="Name" value="%s::/%s">' & @CRLF & _
							'    <param name="Merge" value="%s::/%s">' & @CRLF & _
							'  </object>'
Global $sMergeFiles = '', $sObjects = '', $s7zData
Global $aCHMList, $aHHCData, $aResult[2][1]
Global $h7z
Global $iCount = 0
Global $sTarget

$sTarget = FileSelectFolder('   chm-.   AutoIt3.chm  UDFs3.chm     ', Default, 2, @ScriptDir)
If @error Then Exit

$aCHMList = _FileListToArray($sTarget, "*.chm", 1)

If Not IsArray($aCHMList) Then Exit 1 + 0 * MsgBox(4096, Default, "    chm-!")

For $sCHMFilePath In $aCHMList
	If Not FileExists($sTarget & "\" & $sCHMFilePath) Then ContinueLoop
	If $sCHMFilePath = 'AutoIt.chm' Or $sCHMFilePath = 'AutoIt3.chm' Or $sCHMFilePath = 'UDFs3.chm' Or StringRight($sCHMFilePath, 4) <> '.chm' Then ContinueLoop
	$h7z = Run(@ScriptDir & '\Utils\7z.exe l "' & $sTarget & "\" & $sCHMFilePath & '"', @ScriptDir & '\Utils\', @SW_HIDE, $STDERR_CHILD + $STDOUT_CHILD)

	$s7zData = ''

	While 1
		$s7zData = StdoutRead($h7z)
		If @error Then ExitLoop
		$aHHCData = StringRegExp($s7zData, '.*?\.hhc', 3)
		If IsArray($aHHCData) Then
			ReDim $aResult[2][UBound($aResult, 2) + 1]
			$aResult[0][$iCount] = $sCHMFilePath
			$aResult[1][$iCount] = StringTrimLeft($aHHCData[0], 53)
			$iCount += 1
		EndIf
	Wend
Next

If UBound($aResult, 2) = 1 Then Exit 1 + 0 * MsgBox(4096, Default, "    chm-,   AutoIt.chm, AutoIt3.chm  UDFs3.chm!")
ReDim $aResult[2][UBound($aResult, 2) - 1]

$sMergeFiles &= $asStandartMerge[0] & @CRLF
$sMergeFiles &= $asStandartMerge[2] & @CRLF
$sObjects &= StringFormat($sPatternObject, $asStandartMerge[0], $asStandartMerge[1], $asStandartMerge[0], $asStandartMerge[1]) & @CRLF
$sObjects &= StringFormat($sPatternObject, $asStandartMerge[2], $asStandartMerge[3], $asStandartMerge[2], $asStandartMerge[3]) & @CRLF

For $iCount = 0 To UBound($aResult, 2) - 1
	$sMergeFiles &= $aResult[0][$iCount] & @CRLF
	$sObjects &= StringFormat($sPatternObject, $aResult[0][$iCount], $aResult[1][$iCount], $aResult[0][$iCount], $aResult[1][$iCount]) & @CRLF
Next



$sTemp = _TempFile()
DirCreate($sTemp)
DirCopy(@ScriptDir & "\MainSRC\", $sTemp & "\", 1)
$sAutoItM = FileRead($sTemp & '\AutoItM.hhp')
$sAutoItM = StringFormat($sAutoItM, @ScriptDir & "\", $sMergeFiles)
FileDelete($sTemp & '\AutoItM.hhp')
FileWrite($sTemp & '\AutoItM.hhp', $sAutoItM)

$sAutoItM = FileRead($sTemp & '\AutoItM.hhc')
$sAutoItM = StringFormat($sAutoItM, $sObjects)
FileDelete($sTemp & '\AutoItM.hhc')
FileWrite($sTemp & '\AutoItM.hhc', $sAutoItM)

RunWait(@ScriptDir & '\Utils\hhc.exe "' & $sTemp & '\AutoItM.hhp"', $sTemp, @SW_HIDE)
DirRemove($sTemp & "\")
;~ ShellExecute(@ScriptDir & "\AutoIt.chm")
